const bcrypt = require('bcryptjs');
require('dotenv').config({ path: '.env.local' });

async function generateMasterUser() {
  try {
    // Verificar se as variáveis de ambiente estão definidas
    const email = process.env.MASTER_USER_EMAIL;
    const password = process.env.MASTER_USER_PASSWORD;
    const name = process.env.MASTER_USER_NAME || 'Master Admin';

    if (!email || !password) {
      console.error('❌ Erro: MASTER_USER_EMAIL e MASTER_USER_PASSWORD devem estar definidos no arquivo .env');
      console.log('📝 Exemplo de .env:');
      console.log('MASTER_USER_EMAIL=admin@example.com');
      console.log('MASTER_USER_PASSWORD=sua_senha_segura');
      console.log('MASTER_USER_NAME=Master Admin');
      process.exit(1);
    }

    // Gerar hash da senha
    const saltRounds = 12;
    const hashedPassword = await bcrypt.hash(password, saltRounds);

    console.log('✅ Hash da senha gerado com sucesso!');
    console.log('');
    console.log('📋 SQL para inserir o usuário master:');
    console.log('');
    console.log(`INSERT INTO users (email, password_hash, name, is_master, is_active) VALUES (`);
    console.log(`  '${email}',`);
    console.log(`  '${hashedPassword}',`);
    console.log(`  '${name}',`);
    console.log(`  true,`);
    console.log(`  true`);
    console.log(`) ON CONFLICT (email) DO NOTHING;`);
    console.log('');
    console.log('🔐 Informações de login:');
    console.log(`Email: ${email}`);
    console.log(`Senha: ${password}`);
    console.log('');
    console.log('⚠️  IMPORTANTE: Mantenha essas credenciais seguras e remova este script após o uso!');

  } catch (error) {
    console.error('❌ Erro ao gerar hash:', error);
    process.exit(1);
  }
}

generateMasterUser();