-- Script para permitir que músicas da loja não tenham repertoire_group_id
-- Execute este script no console do Neon Database

-- Alterar a coluna repertoire_group_id para permitir NULL
ALTER TABLE songs ALTER COLUMN repertoire_group_id DROP NOT NULL;

-- Verificar se a alteração foi aplicada
SELECT 
    column_name,
    data_type,
    is_nullable,
    column_default
FROM information_schema.columns 
WHERE table_name = 'songs' 
AND table_schema = 'public'
AND column_name = 'repertoire_group_id';

-- Verificar se existem músicas da loja (sem repertoire_group_id)
SELECT COUNT(*) as music_store_songs
FROM songs 
WHERE repertoire_group_id IS NULL;

-- Verificar se existem músicas de repertório (com repertoire_group_id)
SELECT COUNT(*) as repertoire_songs
FROM songs 
WHERE repertoire_group_id IS NOT NULL;