-- Script para corrigir o trigger da tabela music_categories
-- Execute este script se você recebeu o aviso sobre o trigger não existir

-- Primeiro, verificar se a tabela existe
DO $$
BEGIN
    IF NOT EXISTS (SELECT 1 FROM information_schema.tables WHERE table_name = 'music_categories') THEN
        RAISE EXCEPTION 'Tabela music_categories não existe. Execute primeiro o script 008_create_categories_table.sql';
    END IF;
END $$;

-- Criar ou substituir a função do trigger
CREATE OR REPLACE FUNCTION update_music_categories_updated_at()
RETURNS TRIGGER AS $$
BEGIN
    NEW.updated_at = CURRENT_TIMESTAMP;
    RETURN NEW;
END;
$$ language 'plpgsql';

-- Remover trigger existente se houver
DROP TRIGGER IF EXISTS update_music_categories_updated_at ON music_categories;

-- Criar o trigger
CREATE TRIGGER update_music_categories_updated_at
    BEFORE UPDATE ON music_categories
    FOR EACH ROW
    EXECUTE FUNCTION update_music_categories_updated_at();

-- Verificar se o trigger foi criado com sucesso
DO $$
BEGIN
    IF EXISTS (
        SELECT 1 FROM information_schema.triggers 
        WHERE trigger_name = 'update_music_categories_updated_at' 
        AND event_object_table = 'music_categories'
    ) THEN
        RAISE NOTICE 'Trigger update_music_categories_updated_at criado com sucesso!';
    ELSE
        RAISE EXCEPTION 'Falha ao criar o trigger update_music_categories_updated_at';
    END IF;
END $$;