-- Inserir dados de exemplo para demonstração
-- Usuário de teste
INSERT INTO users (email, password_hash, name, is_active) 
VALUES (
    'usuario@teste.com',
    '$2b$10$8K1p/a0dqbVXiVXnfnQbeOeH.S8MYFuyiZHjo/RyU.JHK.H9Oxzei', -- Hash de '@Sucesso2021'
    'Usuário Teste',
    true
) ON CONFLICT (email) DO NOTHING;

-- Grupos de repertório de exemplo
INSERT INTO repertoire_groups (user_id, name, description, color, position) 
SELECT 
    u.id,
    'Rock Clássico',
    'Grandes sucessos do rock internacional',
    '#EF4444',
    1
FROM users u WHERE u.email = 'usuario@teste.com'
ON CONFLICT DO NOTHING;

INSERT INTO repertoire_groups (user_id, name, description, color, position) 
SELECT 
    u.id,
    'MPB',
    'Música Popular Brasileira',
    '#10B981',
    2
FROM users u WHERE u.email = 'usuario@teste.com'
ON CONFLICT DO NOTHING;

-- Músicas de exemplo
INSERT INTO songs (repertoire_group_id, title, artist, youtube_url, youtube_video_id, position)
SELECT 
    rg.id,
    'Bohemian Rhapsody',
    'Queen',
    'https://www.youtube.com/watch?v=fJ9rUzIMcZQ',
    'fJ9rUzIMcZQ',
    1
FROM repertoire_groups rg 
JOIN users u ON rg.user_id = u.id 
WHERE u.email = 'usuario@teste.com' AND rg.name = 'Rock Clássico'
ON CONFLICT DO NOTHING;

INSERT INTO songs (repertoire_group_id, title, artist, youtube_url, youtube_video_id, position)
SELECT 
    rg.id,
    'Garota de Ipanema',
    'Tom Jobim',
    'https://www.youtube.com/watch?v=UJkxFhFRFDA',
    'UJkxFhFRFDA',
    1
FROM repertoire_groups rg 
JOIN users u ON rg.user_id = u.id 
WHERE u.email = 'usuario@teste.com' AND rg.name = 'MPB'
ON CONFLICT DO NOTHING;
