import { cookies } from "next/headers"

export async function getServerUser() {
  try {
    console.log("[v0] getServerUser called")
    const cookieStore = cookies()
    console.log("[v0] Cookie store obtained")

    // Debug: List all cookies
    const allCookies = cookieStore.getAll()
    console.log(
      "[v0] All available cookies:",
      allCookies.map((c) => c.name),
    )

    const authData = cookieStore.get("auth_data")?.value
    console.log("[v0] Checking auth, cookie exists:", !!authData)
    console.log("[v0] Raw cookie value:", authData ? "present" : "missing")

    if (!authData) {
      console.log("[v0] No auth cookie found")
      return null
    }

    const userData = JSON.parse(authData)
    console.log("[v0] Parsed user data:", { id: userData.id, email: userData.email, type: userData.type })

    // Check if token is expired
    if (userData.expires && userData.expires < Date.now()) {
      console.log("[v0] Auth cookie expired")
      return null
    }

    console.log("[v0] Valid auth found for user:", userData.id)
    return {
      id: userData.id,
      name: userData.name,
      email: userData.email,
      type: userData.type,
    }
  } catch (error) {
    console.error("[v0] Error getting server user:", error)
    return null
  }
}

export function getClientUser() {
  try {
    if (typeof window === "undefined") return null

    const authData = document.cookie
      .split("; ")
      .find((row) => row.startsWith("auth_data="))
      ?.split("=")[1]

    if (!authData) {
      console.log("[v0] No client auth cookie found")
      return null
    }

    const userData = JSON.parse(decodeURIComponent(authData))

    // Check if token is expired
    if (userData.expires && userData.expires < Date.now()) {
      console.log("[v0] Client auth cookie expired")
      return null
    }

    return {
      id: userData.id,
      name: userData.name,
      email: userData.email,
      type: userData.type,
    }
  } catch (error) {
    console.error("[v0] Error getting client user:", error)
    return null
  }
}

export async function clearSession() {
  // Simple clear - no database operations needed
  console.log("[v0] Clearing auth session")
}
