import { NextRequest, NextResponse } from "next/server"
import { neon } from "@neondatabase/serverless"

const sql = neon(process.env.DATABASE_URL!)

// GET - Listar todas as categorias
export async function GET() {
  try {
    const categories = await sql`
      SELECT id, name, created_at
      FROM music_categories 
      ORDER BY name ASC
    `;

    return NextResponse.json(categories);
  } catch (error) {
    console.error('Erro ao buscar categorias:', error);
    return NextResponse.json(
      { error: 'Erro interno do servidor' },
      { status: 500 }
    );
  }
}

// POST - Criar nova categoria
export async function POST(request: NextRequest) {
  try {
    const { name } = await request.json();

    if (!name) {
      return NextResponse.json(
        { error: 'Nome da categoria é obrigatório' },
        { status: 400 }
      );
    }

    const result = await sql`
      INSERT INTO music_categories (name)
      VALUES (${name})
      RETURNING id, name, created_at
    `;

    return NextResponse.json(result[0], { status: 201 });
  } catch (error: any) {
    console.error('Erro ao criar categoria:', error);
    
    if (error.code === '23505') { // Unique constraint violation
      return NextResponse.json(
        { error: 'Categoria com este nome já existe' },
        { status: 409 }
      );
    }

    return NextResponse.json(
      { error: "Erro interno do servidor" },
      { status: 500 }
    )
  }
}