import { NextResponse } from "next/server"
import { clearSession } from "@/lib/auth"

export async function POST() {
  try {
    await clearSession()

    const response = NextResponse.json({ success: true })
    response.cookies.set("auth_data", "", {
      httpOnly: false,
      secure: false,
      sameSite: "lax",
      path: "/",
      maxAge: 0, // Expira imediatamente
    })

    console.log("[v0] User logged out, auth cookie cleared")
    return response
  } catch (error) {
    console.error("Logout error:", error)
    return NextResponse.json({ success: false }, { status: 500 })
  }
}
