import { NextResponse } from "next/server"
import { getServerUser } from "@/lib/auth"
import { cookies } from "next/headers"

export async function GET() {
  try {
    console.log("[v0] Auth check endpoint called")

    // Debug: Check all cookies
    const cookieStore = cookies()
    const allCookies = cookieStore.getAll()
    console.log(
      "[v0] All cookies:",
      allCookies.map((c) => ({ name: c.name, hasValue: !!c.value })),
    )

    const user = await getServerUser()

    if (!user) {
      console.log("[v0] No user found in auth check")
      return NextResponse.json({ authenticated: false }, { status: 401 })
    }

    console.log("[v0] User found in auth check:", { id: user.id, type: user.type })
    return NextResponse.json({
      authenticated: true,
      user,
    })
  } catch (error) {
    console.error("Auth check error:", error)
    return NextResponse.json({ authenticated: false }, { status: 500 })
  }
}

export async function POST(request: Request) {
  try {
    console.log("[v0] Hybrid auth check called")

    const { authData } = await request.json()

    if (!authData || !authData.expires || authData.expires < Date.now()) {
      console.log("[v0] Invalid or expired auth data")
      return NextResponse.json({ authenticated: false }, { status: 401 })
    }

    console.log("[v0] Valid auth data found:", { id: authData.id, type: authData.type })
    return NextResponse.json({
      authenticated: true,
      user: {
        id: authData.id,
        name: authData.name,
        email: authData.email,
        type: authData.type,
      },
    })
  } catch (error) {
    console.error("Hybrid auth check error:", error)
    return NextResponse.json({ authenticated: false }, { status: 500 })
  }
}
