# 🚀 Guia de Deploy para cPanel - Repertório Musical

## 📋 Pré-requisitos

1. **Hospedagem com suporte a Node.js** (versão 18+)
2. **Banco de dados PostgreSQL** (recomendado: Neon, Supabase, ou PostgreSQL no cPanel)
3. **Acesso ao cPanel** com File Manager
4. **Terminal SSH** (opcional, mas recomendado)

## 🔧 Passo 1: Preparar o Projeto para Produção

### 1.1 Configurar Variáveis de Ambiente

✅ **Arquivo `.env.production` já configurado com suas informações:**

```bash
# Database Configuration - Neon PostgreSQL
DATABASE_URL=postgresql://neondb_owner:npg_UOAik7P4RMDy@ep-fragrant-cherry-acdsxy1y-pooler.sa-east-1.aws.neon.tech/neondb?sslmode=require

# Master User Configuration
MASTER_USER_EMAIL=creativegrowgarca@gmail.com
MASTER_USER_NAME=Creative Grow
MASTER_USER_PASSWORD=@Sucesso2021

# Security Configuration
NODE_ENV=production
NEXTAUTH_SECRET=repertorio-production-secret-key-2024-super-secure-change-this

# Application Configuration - URL de Produção
NEXT_PUBLIC_APP_URL=https://repertorio.rgestor.com.br
NEXTAUTH_URL=https://repertorio.rgestor.com.br

# Configurações de CORS
ALLOWED_ORIGINS=https://repertorio.rgestor.com.br
```

**✅ Suas configurações estão prontas para produção!**

### 1.2 Gerar Build de Produção

```bash
# No seu computador local
npm run build
```

## 🗄️ Passo 2: Configurar Banco de Dados

✅ **Seu banco de dados Neon já está configurado e funcionando!**

Como você está usando o mesmo banco de dados do desenvolvimento (Neon), não precisa criar um novo banco ou migrar dados. O banco já contém:

- ✅ Todas as tabelas necessárias
- ✅ Usuário master configurado
- ✅ Dados de exemplo (se aplicável)
- ✅ Conexão SSL segura

**Nenhuma ação adicional necessária para o banco de dados.**

## 📁 Passo 3: Upload dos Arquivos

### 3.1 Arquivos Necessários para Upload

Faça upload dos seguintes arquivos/pastas para o `public_html` (ou pasta do domínio):

```
📁 Estrutura no servidor:
├── .next/                 # Pasta gerada pelo build
├── app/                   # Código da aplicação
├── components/            # Componentes React
├── lib/                   # Bibliotecas e utilitários
├── public/               # Arquivos estáticos
├── styles/               # Estilos CSS
├── .env.production       # Variáveis de ambiente
├── next.config.mjs       # Configuração do Next.js
├── package.json          # Dependências
├── package-lock.json     # Lock das dependências
└── tsconfig.json         # Configuração TypeScript
```

### 3.2 Arquivos que NÃO devem ser enviados

```
❌ NÃO enviar:
├── .env.local            # Ambiente local
├── .git/                 # Controle de versão
├── node_modules/         # Dependências (serão instaladas no servidor)
├── .next/cache/          # Cache local
└── *.log                 # Logs locais
```

## ⚙️ Passo 4: Configurar Node.js no cPanel

### 4.1 Acessar Node.js App

1. No cPanel, procure por "Node.js App" ou "Node.js Selector"
2. Clique em "Create Application"

### 4.2 Configurações da Aplicação

```
Application Root: public_html (ou pasta do seu domínio)
Application URL: / (ou subpasta se aplicável)
Application Startup File: server.js
Node.js Version: 18.x ou superior
```

### 4.3 Criar arquivo server.js

Crie o arquivo `server.js` na raiz do projeto:

```javascript
const { createServer } = require('http')
const { parse } = require('url')
const next = require('next')

const dev = process.env.NODE_ENV !== 'production'
const hostname = 'localhost'
const port = process.env.PORT || 3000

const app = next({ dev, hostname, port })
const handle = app.getRequestHandler()

app.prepare().then(() => {
  createServer(async (req, res) => {
    try {
      const parsedUrl = parse(req.url, true)
      await handle(req, res, parsedUrl)
    } catch (err) {
      console.error('Error occurred handling', req.url, err)
      res.statusCode = 500
      res.end('internal server error')
    }
  }).listen(port, (err) => {
    if (err) throw err
    console.log(\`> Ready on http://\${hostname}:\${port}\`)
  })
})
```

## 📦 Passo 5: Instalar Dependências

### Via Terminal SSH (Recomendado)

```bash
# Conecte via SSH e navegue até a pasta do projeto
cd public_html

# Instale as dependências
npm install --production

# Gere o build (se não foi feito localmente)
npm run build
```

### Via cPanel Node.js App

1. Na seção "Node.js App", clique na sua aplicação
2. Na aba "Package.json", clique em "Run NPM Install"
3. Aguarde a instalação das dependências

## 🔄 Passo 6: Configurar Variáveis de Ambiente no cPanel

1. Na seção "Node.js App", clique na sua aplicação
2. Na aba "Environment Variables", adicione:

```
NODE_ENV=production
DATABASE_URL=sua_url_do_banco
NEXTAUTH_SECRET=seu_secret_seguro
NEXTAUTH_URL=https://seudominio.com
```

## 🚀 Passo 7: Iniciar a Aplicação

1. Na seção "Node.js App", clique em "Start App"
2. Aguarde alguns segundos para a aplicação inicializar
3. Acesse seu domínio para testar

## 🔍 Passo 8: Verificar e Testar

### 8.1 Verificações Essenciais

- [ ] Aplicação carrega sem erros
- [ ] Login funciona corretamente
- [ ] Banco de dados conecta
- [ ] Adicionar músicas funciona
- [ ] Interface responsiva

### 8.2 Logs de Erro

Para verificar erros:
1. cPanel → "Node.js App" → sua aplicação → "Logs"
2. Ou via SSH: `tail -f logs/error.log`

## 🛠️ Solução de Problemas Comuns

### Erro: "Module not found"
```bash
# Reinstale as dependências
npm install --production
```

### Erro: "Database connection failed"
- Verifique a `DATABASE_URL` no arquivo `.env.production`
- Teste a conexão com o banco separadamente

### Erro: "Port already in use"
- Reinicie a aplicação no cPanel
- Verifique se não há outras aplicações Node.js rodando

### Erro: "Build failed"
```bash
# Limpe o cache e rebuilde
rm -rf .next
npm run build
```

## 📞 Suporte

Se encontrar problemas:
1. Verifique os logs de erro
2. Confirme se todas as variáveis de ambiente estão corretas
3. Teste a conexão com o banco de dados
4. Verifique se a versão do Node.js é compatível (18+)

## 🔄 Atualizações Futuras

Para atualizar a aplicação:
1. Faça as alterações localmente
2. Execute `npm run build`
3. Faça upload dos arquivos alterados
4. Reinicie a aplicação no cPanel

---

**✅ Pronto! Sua aplicação de repertório musical está em produção!** 🎵